#include <stdio.h>
#include <stdlib.h>
//#include <memory.h>
#include "../x68k/m68000.h"
#include "../x68k/d68k.h"

#include <windows.h>

#define UINT8 unsigned char
#define UINT16 unsigned short
#define UINT32 unsigned int
#define INT8 signed char
#define INT16 signed short
#define INT32 signed int
#define SINT32 signed int


	char *mapped;

	char hook_trace;
	int trace_map;

	FILE* fp_hook;
	FILE* fp_trace;
	FILE* fp_call;


extern	char	winx68k_dir[MAX_PATH];

#define STATES 3
	unsigned int *rd_mode, *wr_mode, *ppu_mode, *pc_mode;
	unsigned int *rd_low, *rd_high;
	unsigned int *wr_low, *wr_high;
	unsigned int *ppu_low, *ppu_high;
	unsigned int *pc_low, *pc_high;
	unsigned int *pc_start;

	int hook_pc;
	int hook_address;
	int hook_value;

	void hook_read_byte();
	void hook_read_word();
	void hook_write_byte();
	void hook_write_word();

	void Hook_Dummy();
	void DeInitDebug();


void Hook_Dummy()
{
	return;
}


void DeInitDebug()
{
	if( fp_hook )
	{
		fclose( fp_hook );
	}

	if( rd_mode )
	{
		free( rd_mode );
		free( wr_mode );
		free( pc_mode );
		free( ppu_mode );

		free( rd_low );
		free( wr_low );
		free( pc_low );
		free( ppu_low );

		free( rd_high );
		free( wr_high );
		free( pc_high );
		free( ppu_high );

		free( pc_start );
	}

	if( fp_trace )
	{
		free( mapped );
		fclose( fp_trace );
	}
}


char buffer[1024];
void Print_Instruction( FILE *trace )
{
	static DWORD oldpc;

	//if (oldpc!=hook_pc)
	{
		m68k_disassemble(buffer, hook_pc);
	
		fprintf(trace, "<%04X> %06X : %-35s", Memory_ReadW(hook_pc), hook_pc, buffer);
		fprintf(trace, " D0:%08X D1:%08X D2:%08X D3:%08X D4:%08X D5:%08X D6:%08X D7:%08X CR:%04X", regs.d[0], regs.d[1], regs.d[2], regs.d[3], regs.d[4], regs.d[5], regs.d[6], regs.d[7], regs.ccr);
		fprintf(trace, " A0:%08X A1:%08X A2:%08X A3:%08X A4:%08X A5:%08X A6:%08X A7:%08X SR:%04X", regs.a[0], regs.a[1], regs.a[2], regs.a[3], regs.a[4], regs.a[5], regs.a[6], regs.a[7], regs.sr_high);
	}
	oldpc = hook_pc;
	
	fprintf( trace, "\n" );
}


void Trace_X68()
{
	int bank,offset;
	int type;

	hook_pc &= 0x00ffffff;


	//if(hook_pc==0x1559d)
		//hook_pc+=0;


	// Trace.txt
	if( trace_map )
	{
		if( !fp_trace )
		{
			char buf[1024];
			sprintf( buf, "%s%s", winx68k_dir, "trace.log" );
			fp_trace=fopen(buf,"w");

			mapped = malloc( 0x100*0x10000 );
			memset( mapped,0,0x100*0x10000 );
		}

		if( !mapped[ hook_pc ] )
		{
			Print_Instruction( fp_trace );
			mapped[ hook_pc ] = 1;
		}
	}


	// Hook.txt
	if( hook_trace )
	{
		int lcv, old_pc;
		for( lcv = 0; lcv < STATES; lcv++ )
		{
			FILE *out;

			// start-stop
			if( pc_mode[ lcv ] & 1 )
			{
				if( hook_pc == pc_low[lcv] )
					pc_start[lcv] = 1;

				if( !pc_start[lcv] ) continue;

				out = fp_hook;
			}
			// low-high
			else
			{
				// fail: outside boundaries
				if( hook_pc < pc_low[ lcv ] ) continue;
				if( hook_pc > pc_high[ lcv ] ) continue;
			}

// ------------------------------------------------------

			if( pc_mode[ lcv ] >= 4 && pc_mode[ lcv ] < 8 )
			{
				pc_mode[ lcv ] &= 3;
				trace_map = 1;
			}

			// output file mode
			out = ( pc_mode[ lcv ] <= 1 ) ? fp_hook : fp_trace;

			if( !out ) continue;
			if( out == fp_trace )
				fprintf( out, "** " );

			
			old_pc = hook_pc;
			Print_Instruction( out );
			hook_pc = old_pc;


			// end formatting
			if( hook_pc == pc_high[lcv] )
			{
				if( pc_start[lcv] )
				{
					if( pc_low[ lcv ] != pc_high[ lcv ] )
						fprintf( out, "\n" );
				}

				pc_start[lcv] = 0;
			}
		} // end STATES
	} // end hook
}


void hook_read_byte()
{
	unsigned int start, stop;
	int lcv;

	if( !hook_trace ) return;

	//hook_pc = regs.pc;
	
	hook_pc &= 0x00ffffff;
	hook_address &= 0x00ffffff;
	hook_value &= 0xff;

	start = hook_address;
	stop = start + 0;

	for( lcv=0; lcv<STATES; lcv++ )
	{
		FILE *out;

		// linear map
		if( rd_mode[ lcv ] & 1 )
		{
			// fail: outside boundaries
			if( stop < rd_low[ lcv ] ) continue;
			if( start > rd_high[ lcv ] ) continue;
		}
		// shadow map
		else
		{
			// fail: outside boundaries
			if( ( stop & 0xffff ) < ( rd_low[ lcv ] & 0xffff ) ) continue;
			if( ( start & 0xffff ) > ( rd_high[ lcv ] & 0xffff ) ) continue;
			
			if( ( stop >> 16 ) < ( rd_low[ lcv ] >> 16 ) ) continue;
			if( ( start >> 16 ) > ( rd_high[ lcv ] >> 16 ) ) continue;
		}

// ------------------------------------------------------

		// auto-trace
		if( rd_mode[ lcv ] >= 4 && rd_mode[ lcv ] < 8 )
		{
			rd_mode[ lcv ] &= 3;
			trace_map = 1;

			hook_trace = 0;
			Trace_X68();
			hook_trace = 1;
		}

		// output file mode
		out = ( rd_mode[ lcv ] <= 1 ) ? fp_hook : fp_trace;

		if( !out ) continue;
		if( out == fp_trace )
			fprintf( out, "** " );

		fprintf( out, "[%02x:%04X] %s = %02X [%06X]\n",
			hook_pc >> 16, hook_pc & 0xffff, "R08",
			hook_value & 0xff, hook_address );
	}
}


void hook_write_byte()
{
	unsigned int start, stop;
	int lcv;

	if( !hook_trace ) return;

	// reset PC tracer
	hook_address &= 0x00ffffff;
	if( mapped )
		mapped[ hook_address ] = 0;

	//hook_pc = regs.pc;

	hook_pc &= 0x00ffffff;
	hook_address &= 0x00ffffff;
	hook_value &= 0xff;

	start = hook_address;
	stop = start + 0;

	for( lcv = 0; lcv < STATES; lcv++ )
	{
		FILE *out;

		// linear map
		if( wr_mode[ lcv ] & 1 )
		{
			// fail: outside boundaries
			if( stop < wr_low[ lcv ] ) continue;
			if( start > wr_high[ lcv ] ) continue;
		}
		// shadow map
		else
		{
			// fail: outside boundaries
			if( ( stop & 0xffff ) < ( wr_low[ lcv ] & 0xffff ) ) continue;
			if( ( start & 0xffff ) > ( wr_high[ lcv ] & 0xffff ) ) continue;
			
			if( ( stop >> 16 ) < ( wr_low[ lcv ] >> 16 ) ) continue;
			if( ( start >> 16 ) > ( wr_high[ lcv ] >> 16 ) ) continue;
		}

// ------------------------------------------------------

		// auto-trace
		if( wr_mode[ lcv ] >= 4 && wr_mode[ lcv ] < 8 )
		{
			wr_mode[ lcv ] &= 3;
			trace_map = 1;

			hook_trace = 0;
			Trace_X68();
			hook_trace = 1;
		}

		// output file mode
		out = ( wr_mode[ lcv ] <= 1 ) ? fp_hook : fp_trace;

		if( !out ) continue;
		if( out == fp_trace )
			fprintf( out, "** " );

		fprintf( out, "[%02X:%04X] %s = %02X [%06X]\n",
			hook_pc >> 16, hook_pc & 0xffff, "W08",
			hook_value & 0xff, hook_address );
	}
}
